/*
Macro_Scripts File
Purposes:  
    
	define action items for Lighting Analysis related tools

Revision History

	Nov 7th, 2007, Pierre-Felix Breton
		Creation of macroscripts




*/

--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK




------------------------------------------------------------------------------
macroScript LightingAnalysisAssistantToggle
            category:~LIGHTINGANALYSISASSISTANTTOGGLE_CATEGORY~ 
            internalCategory:"Lighting Analysis" 
            tooltip:~LIGHTINGANALYSISASSISTANTTOGGLE_TOOLTIP~
			ButtonText:~LIGHTINGANALYSISASSISTANTTOGGLE_BUTTONTEXT~ 
(
    on execute do
    (
		Try (daylightsimulationuiops.visible = true)	
		Catch()
		
		
    )--end on execute
    
    
    
    on closedialogs do
    (
		Try (daylightsimulationuiops.visible = false)	
		Catch()
		
    )--end on execute
    on isChecked return try (daylightsimulationuiops.visible) catch(false)
)


------------------------------------------------------------------------------
-- adds a Lighting Analysis Image Overlay Effect and Launch the Render Effect Dialog
macroScript RenderEffectLightingAnalysisImageOverlayAdd
            category:~RENDEREFFECTLIGHTINGANALYSISIMAGEOVERLAYADD_CATEGORY~ 
            internalCategory:"Lighting Analysis" 
            tooltip:~RENDEREFFECTLIGHTINGANALYSISIMAGEOVERLAYADD_TOOLTIP~
			ButtonText:~RENDEREFFECTLIGHTINGANALYSISIMAGEOVERLAYADD_BUTTONTEXT~ 
(
    on execute do
    (
    	---searches for lighting analysis image overlays in the render effect Dialog
    	-- add one if needed
    	-- launch the dialog with the focus on it

			local i = 0
			local j = 0
			local fx
			local fxClass
			
			--loop through scene effects to find a Lighting_Analysis_Overlay render effect
			--variable j will contain the last occurence of the Lighting_Analysis_Overlay render effect's index
			for i = 1 to numEffects do
			(
				fx = getEffect i
				fxClass = ((classof fx) as string) as name
				if fxClass == #Lighting_Analysis_Overlay do j = i
			)
			
			--if j is zero then we have not found it
			if j == 0 do 
			(	
				--add the effect since we have not found it
				addEffect (Lighting_Analysis_Overlay ())
				-- since we are adding the effect, its necessarly at the end of the list, thus the j being set to numEffects
				j = numEffects
			)
			
			--okay, now we can launch the Effects dialog and set to focus to the Lighting Analysis Effect, wheter we created it or not.
			editEffect (getEffect j)
	

    	
    )--end on execute
   
)


------------------------------------------------------------------------------
-- Set the daylight system to cast real time shadows in viewport

macroScript Daylight_Viewport_Lighting
            category:~DAYLIGHT_VIEWPORT_LIGHTING_CATEGORY~ 
            internalCategory:"Lighting Analysis" 
            tooltip:~DAYLIGHT_VIEWPORT_LIGHTING_TOOLTIP~
			ButtonText:~VIEWPORT_SHADOWS_BUTTONTEXT~
(
    on execute do
    (
		Try (messagebox ~MSGBOX_NOT_YET_IMPLEMENTED_CAPTION~)	
		Catch()
		
    )--end on execute
)


------------------------------------------------------------------------------
-- Pops up a browser which goes to a webpage to learn more about lighting analysis
macroScript Daylight_Learn_More
			buttontext:~LEARN_MORE_BUTTONTEXT~
			category:~LIGHTING_ANALYSIS_CATEGORY~ 
			internalCategory:"Lighting Analysis" 
			tooltip:~LEARN_MORE_TOOLTIP~ 
(
	local fname = "http://www.autodesk.com/3dsmaxdesign-whitepapers"
	local strMsgTitle = "3ds Max"
	local strErrMsg = ~STRERRMSG_CAPTION~
		
	On Execute Do
	(
		try
		(
			if (fname != undefined) do
			(
				res = ShellLaunch (fname) ""
				if (res == false) then
					MessageBox strErrMsg  title:strMsgTitle
			)
		) 
		catch()
	)
)

